/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/
package org.jboss.remoting.network;

import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.ident.Identity;

import javax.management.MBeanRegistration;
import javax.management.NotificationBroadcaster;

/**
 * NetworkRegistryMBean is a managed bean that keeps track of all the servers on a
 * JBOSS network, and associates all the valid invokers on each server that are
 * available.
 *
 * @author <a href="mailto:jhaynie@vocalocity.net">Jeff Haynie</a>
 * @version $Revision:1$
 */
public interface NetworkRegistryMBean extends NotificationBroadcaster, MBeanRegistration
{
    /**
     * return the servers on the network
     *
     * @return
     */
    public NetworkInstance[] getServers ();

    /**
     * add a server for a given identity that is available on the network
     *
     * @param identity
     * @param invokers
     */
    public void addServer (Identity identity, InvokerLocator invokers[]);

    /**
     * remove a server no longer available on the network
     *
     * @param identity
     */
    public void removeServer (Identity identity);

    /**
     * update the invokers for a given server
     *
     * @param identity
     * @param invokers
     */
    public void updateServer (Identity identity, InvokerLocator invokers[]);

    /**
     * returns true if the server with the identity is available
     *
     * @param identity
     * @return
     */
    public boolean hasServer (Identity identity);

    /**
     * query the network registry for <tt>0..*</tt> of servers based on a
     * filter
     *
     * @param filter
     * @return
     */
    public NetworkInstance[] queryServers (NetworkFilter filter);

    /**
     * change the main domain of the local server
     *
     * @param newDomain
     */
    public void changeDomain (String newDomain);
}
