/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/
package org.jboss.remoting.network;

import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.ident.Identity;

import java.io.Serializable;

/**
 * NetworkFilter can be used when selecting <tt>0..*</tt> servers on the network
 * from the NetworkRegistry
 *
 * @author <a href="mailto:jhaynie@vocalocity.net">Jeff Haynie</a>
 * @version $Revision:1$
 */
public interface NetworkFilter extends Serializable
{
    /**
     * called to apply a filter when selecting <tt>0..*</tt> servers on the network
     *
     * @param identity
     * @param locators
     * @return
     */
    public boolean filter (Identity identity, InvokerLocator locators[]);
}
