/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 *
 */

package org.jboss.remoting.invocation;

import java.lang.reflect.Method;

/**
 * NameBasedInvocation.java is an invocation object in jmx style.
 * <p/>
 * <p/>
 * Created: Mon Apr 28 09:14:46 2003
 *
 * @author <a href="mailto:d_jencks@users.sourceforge.net">David Jencks</a>
 * @version 1.0
 */
public class NameBasedInvocation extends RemoteInvocation
{
   /** @since 4.0.1 */
   static final long serialVersionUID = -6507163932605308471L;

   private final String[] sig;

   public NameBasedInvocation(final Method method, final Object[] params)
   {
      super(method.getName(), params);
      sig=generateSignatureFromMethod(method);
   }

   private String[] generateSignatureFromMethod(final Method method)
   {
      Class[] parameterTypes=method.getParameterTypes();
      String[] signature=new String[parameterTypes.length];
      for(int i=0; i < parameterTypes.length; i++) {
         Class parameterType=parameterTypes[i];
         signature[i]=parameterType.getName();
      }
      return signature;
   }

   public NameBasedInvocation(final String methodName, final Object[] params, final String[] sig)
   {
      super(methodName, params);
      this.sig = sig;
   } // NameBasedInvocation constructor

   public String[] getSignature()
   {
      return sig;
   }

   public String toString()
   {
      return "NameBasedInvocation [" + methodName + "]";
   }

} // NameBasedInvocation
