/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 *
 */

package org.jboss.remoting.invocation;


/**
 * InternalInvocation.java is an invocation object for use in the
 * remoting layer for callbacks etc.  We are responsible for assuring
 * that each method name has a unique arg list.
 * <p/>
 * <p/>
 * Created: Mon Apr 28 09:14:46 2003
 *
 * @author <a href="mailto:d_jencks@users.sourceforge.net">David Jencks</a>
 * @author <a href="mailto:telrod@e2technologies.net">Tom Elrod</a>
 * @version 1.0
 */
public class InternalInvocation extends RemoteInvocation

{

   public static final String ADDCLIENTLISTENER = "addClientListener";
   public static final String ADDLISTENER = "addListener";
   public static final String REMOVELISTENER = "removeListener";
   public static final String REMOVECLIENTLISTENER = "removeClientListener";
   public static final String GETCALLBACKS = "getCallbacks";
   public static final String HANDLECALLBACK = "handleCallback";

   public InternalInvocation(final String methodName, final Object[] params)
   {
      super(methodName, params);
   }
}
