/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/
package org.jboss.remoting.detection;

import javax.management.MBeanRegistration;

/**
 * Detector
 *
 * @author <a href="mailto:jhaynie@vocalocity.net">Jeff Haynie</a>
 * @version $Revision:1$
 */
public interface Detector extends MBeanRegistration
{
    /**
     * called by MBeanServer to start the mbean lifecycle
     *
     * @throws Exception
     */
    public void start () throws Exception;

    /**
     * called by the MBeanServer to stop the mbean lifecycle
     *
     * @throws Exception
     */
    public void stop () throws Exception;
}
