/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.remoting;

import java.util.Map;


/**
 * @author <a href="mailto:tom.elrod@jboss.com">Tom Elrod</a>
 */
public class Callback extends InvocationRequest
{
   static final long serialVersionUID = -4778964132014467531L;

   public final static String CALLBACK_HANDLE_OBJECT_KEY = "callback_handle_object";
   public final static String SERVER_LOCATOR_KEY = "server_locator";

   public Callback ( Object callbackPayload)
   {
      super(callbackPayload);
   }

   public Object getCallbackHandleObject()
   {
      Object handleObject = null;
      Map returnPayload = getReturnPayload();
      if(returnPayload != null)
      {
         handleObject = returnPayload.get(CALLBACK_HANDLE_OBJECT_KEY);
      }
      return handleObject;
   }

   public Object getCallbackObject()
   {
      return getParameter();
   }

   public InvokerLocator getServerLocator()
   {
      InvokerLocator locator = null;
      Map returnPayload = getReturnPayload();
      if(returnPayload != null)
      {
         locator = (InvokerLocator)returnPayload.get(SERVER_LOCATOR_KEY);
      }
      return locator;
   }
}