/*
* JBoss, the OpenSource J2EE webOS
*
* Distributable under LGPL license.
* See terms of license at gnu.org.
*/
package org.jnp.interfaces;

import java.util.Collection;
import java.util.Iterator;

import javax.naming.NamingEnumeration;

/**
 *  A NamingEnumeration for the Context list/listBindings methods.
 * 
 * @author Rickard Oberg
 * @author Scott.Stark@jboss.org
 * @version $Revision:1$
 */
public class NamingEnumerationImpl
   implements NamingEnumeration
{
   // Constants -----------------------------------------------------
 
   // Attributes ----------------------------------------------------
   Iterator iter;
    
   // Static --------------------------------------------------------
   
   // Constructors --------------------------------------------------
   NamingEnumerationImpl(Collection list)
   {
      iter = list.iterator();
   }
   
   // Public --------------------------------------------------------

   // Enumeration implementation ------------------------------------
   public boolean hasMoreElements()
   {
      return iter.hasNext();
   }
   
   public Object nextElement()
   {
      return iter.next();
   }

   // NamingEnumeration implementation ------------------------------
   public boolean hasMore()
   {
      return iter.hasNext();
   }
   
   public Object next()
   {
      return iter.next();
   }
   
   public void close()
   {
      iter = null;
   }

   // Y overrides ---------------------------------------------------

   // Package protected ---------------------------------------------
    
   // Protected -----------------------------------------------------
    
   // Private -------------------------------------------------------

   // Inner classes -------------------------------------------------
}