/*
* JBoss, the OpenSource J2EE webOS
*
* Distributable under LGPL license.
* See terms of license at gnu.org.
*/
package org.jnp.interfaces;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Collection;


import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;

/**
 * The interface for the rmi connection to the jndi server implementation
 * 
 * @author Rickard Oberg
 * @author Scott.Stark@jboss.org
 * @version $Revision:1$
 */
public interface Naming
   extends Remote
{
   // Public --------------------------------------------------------
   public void bind(Name name, Object obj, String className)
      throws NamingException, RemoteException;

   public void rebind(Name name, Object obj, String className)
      throws NamingException, RemoteException;

   public void unbind(Name name)
      throws NamingException, RemoteException;

   public Object lookup(Name name)
      throws NamingException, RemoteException;

   public Collection list(Name name)
      throws NamingException, RemoteException;

   public Collection listBindings(Name name)
      throws NamingException, RemoteException;
      
   public Context createSubcontext(Name name)
      throws NamingException, RemoteException;
}
