/*
* JBoss, the OpenSource J2EE webOS
*
* Distributable under LGPL license.
* See terms of license at gnu.org.
*/
package org.jnp.interfaces;

import java.io.IOException;
import java.io.Serializable;
import java.rmi.MarshalledObject;

/** An encapsulation of a JNDI binding as both the raw object and its
 MarshalledObject form. When accessed in the same VM as the JNP server,
 the raw object reference is used to avoid deserialization.

 @author Scott.Stark@jboss.org
 @version $Revision:1$
 */
public class MarshalledValuePair implements Serializable
{
   /** @since 3.2.0 */
   private static final long serialVersionUID = -3403843515711139134L;

   private static boolean enableCallByReference = true;
   public MarshalledObject marshalledValue;
   public transient Object value;

   /** Get the lookp call by reference flag.
    * @return false if all lookups are unmarshalled using the caller's TCL,
    *    true if in VM lookups return the value by reference.
    */ 
   public static boolean getEnableCallByReference()
   {
      return enableCallByReference;
   }
   /** Set the lookp call by reference flag.
    * @param flag - false if all lookups are unmarshalled using the caller's TCL,
    *    true if in VM lookups return the value by reference.
    */ 
   public static void setEnableCallByReference(boolean flag)
   {
      enableCallByReference = flag;
   }

   /** Creates a new instance of MashalledValuePair */
   public MarshalledValuePair(Object value) throws IOException
   {
      this.value = value;
      this.marshalledValue = new MarshalledObject(value);
   }

   public Object get() throws ClassNotFoundException, IOException
   {
      Object theValue = enableCallByReference ? value : null;
      if( theValue == null && marshalledValue != null )
         theValue = marshalledValue.get();
      return theValue;
   }
}
