/*
 * JBossMQ, the OpenSource JMS implementation
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.mq.pm.none;

import javax.jms.JMSException;

import org.jboss.mq.SpyMessage;

/**
 * A persistence manager and cache store that does not persistence.
 * This implements the optimized Topic persistence manager
 *
 * @author Adrian Brock (adrian@jboss.org)
 *
 *  @version $Revision:1$
 */
public class NewPersistenceManager
   extends PersistenceManager
   implements org.jboss.mq.pm.NewPersistenceManager
{
   // Constants --------------------------------------------------------------------

   // Attributes -------------------------------------------------------------------
   
   // Constructors -----------------------------------------------------------------
   
   // Public -----------------------------------------------------------------------
   
   // NewPersistenceManager implementation -----------------------------------------
   
   public void addMessage(SpyMessage message) throws JMSException
   {
      if (delegate != null)
         ((org.jboss.mq.pm.NewPersistenceManager) delegate).addMessage(message);
   }
   
   // ServerMBeanSupport overrides -------------------------------------------------

   protected void startService() throws Exception
   {
      super.startService();
      if (delegate != null && (delegate instanceof org.jboss.mq.pm.NewPersistenceManager) == false)
            throw new UnsupportedOperationException("The delegate persistence manager must be a NewPersistenceManager");
   }
   
   // Protected --------------------------------------------------------------------

   // Inner Classes ----------------------------------------------------------------
}
