/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

package org.jboss.mq.pm;

import javax.management.ObjectName;

import org.jboss.mx.util.ObjectNameFactory;

/**
 * The JMX managment interface for {@link PersistenceManager} MBean.
 *
 * @author <a href="mailto:d_jencks@users.sourceforge.net">david jencks</a>
 * @author <a href="mailto:adrian@jboss.org">Adrian Brock</a>
 * @version $Revision:1$
 */
public interface PersistenceManagerMBean 
{
   // Constants -----------------------------------------------------
   
   /** The object name */
   ObjectName OBJECT_NAME = ObjectNameFactory.create("jboss.mq:service=PersistenceManager");
   
   // Public --------------------------------------------------------

   /**
    * Get the persistence manager instance
    * 
    * @return the persistence manager
    */
   Object getInstance();

   /**
    * Get the object name of the cache
    *
    * @return the object name of the cache
    */
   ObjectName getMessageCache();

   
   /**
    * Set the object name of the message cache
    *
    * @param messageCache the object name
    */
   void setMessageCache(ObjectName messageCache);
}
