/*
 * JBossMQ, the OpenSource JMS implementation
 * 
 * Distributable under LGPL license. See terms of license at gnu.org.
 */
package org.jboss.mq.pm;

import javax.jms.JMSException;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.server.MessageReference;

/**
 * A cache store.
 * 
 * @author Hiram Chirino (Cojonudo14@hotmail.com)
 * @author Paul Kendall (paul.kendall@orion.co.nz)
 * @author <a href="mailto:adrian@jboss.org">Adrian Brock</a>
 * @version $Revision:1$
 */
public interface CacheStore
{
   // Constants -----------------------------------------------------

   // Public --------------------------------------------------------

   /**
	 * Reads the message refered to by the MessagReference back as a SpyMessage
	 * 
	 * @param mh the message reference
    * @return the message
	 * @throws JMSException for any error
	 */
   SpyMessage loadFromStorage(MessageReference mh) throws JMSException;

   /**
	 * Stores the given message to secondary storeage. You should be able to use
	 * the MessagReference to load the message back later.
	 * 
    * @param mh the message reference
    * @param message the message
    * @throws JMSException for any error
	 */
   void saveToStorage(MessageReference mh, SpyMessage message) throws JMSException;

   /**
	 * Removes the message that was stored in secondary storage.
	 * 
    * @param mh the message reference
    * @throws JMSException for any error
	 */
   void removeFromStorage(MessageReference mh) throws JMSException;
}