/*
 * JBossMQ, the OpenSource JMS implementation
 * 
 * Distributable under LGPL license. See terms of license at gnu.org.
 */
package org.jboss.mq;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Topic;
import javax.jms.TopicPublisher;

/**
 * This class implements javax.jms.TopicPublisher
 * 
 * A publisher created with a null Topic will now be interpreted as created as
 * an unidentifyed publisher and follows the spec in throwing
 * UnsupportedOperationException at the correct places.
 * 
 * @author Norbert Lataille (Norbert.Lataille@m4x.org)
 * @author Hiram Chirino (Cojonudo14@hotmail.com)
 * @author <a href="pra@tim.se">Peter Antman</a>
 * @author <a href="mailto:adrian@jboss.org">Adrian Brock</a>
 * @version $Revision:1$
 */
public class SpyTopicPublisher extends SpyMessageProducer implements TopicPublisher
{
   // Constants -----------------------------------------------------

   // Attributes ----------------------------------------------------

   // Static --------------------------------------------------------

   // Constructors --------------------------------------------------

   /**
	 * Create a new SpyTopicPublisher
	 * 
	 * @param s the session
	 * @param t the topic
	 */
   SpyTopicPublisher(SpySession s, Topic t)
   {
      super(s, t);
   }

   // Public --------------------------------------------------------

   // TopicPublisher implementation ---------------------------------

   public Topic getTopic() throws JMSException
   {
      return (Topic) getDestination();
   }

   public void publish(Message message) throws JMSException
   {
      send(message);
   }

   public void publish(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException
   {
      send(message, deliveryMode, priority, timeToLive);
   }

   public void publish(Topic topic, Message message) throws JMSException
   {
      send(topic, message);
   }

   public void publish(Topic topic, Message message, int deliveryMode, int priority, long timeToLive)
         throws JMSException
   {
      send(topic, message, deliveryMode, priority, timeToLive);
   }

   // Package protected ---------------------------------------------

   // Protected -----------------------------------------------------

   // Private -------------------------------------------------------

   // Inner classes -------------------------------------------------

   // Public --------------------------------------------------------

}