/*
 * JBossMQ, the OpenSource JMS implementation
 * 
 * Distributable under LGPL license. See terms of license at gnu.org.
 */
package org.jboss.mq;

import javax.jms.JMSException;
import javax.jms.TemporaryTopic;

/**
 * This class implements javax.jms.TemporaryTopic
 *
 * @author Norbert Lataille (Norbert.Lataille@m4x.org)
 * @author Hiram Chirino (Cojonudo14@hotmail.com)
 * @author <a href="mailto:adrian@jboss.org">Adrian Brock</a>
 * @version $Revision:1$
 */
public class SpyTemporaryTopic extends SpyTopic implements TemporaryTopic
{
   // Constants -----------------------------------------------------

   /** The serialVersionUID */
   static final long serialVersionUID = 1161107878857363598L;   

   // Attributes ----------------------------------------------------
   
   /** The DistributedConnection of its creator */
   ConnectionToken dc;

   /** Connection to the creator used from the client side */
   private transient Connection con = null;

   // Static --------------------------------------------------------
   
   // Constructors --------------------------------------------------
   
   /**
    * Create a new SpyTemporaryTopic
    *
    * @param topicName the topic name
    * @param dc_ the connection token
    */
   public SpyTemporaryTopic(String topicName, ConnectionToken dc_)
   {
      super(topicName);
      dc = dc_;
   }
   
   // Public --------------------------------------------------------

   /**
    * Client-side temporary topics need a reference to the connection that
    * created them in case delete() is called.
    * 
    * @param con the connection
    */
   public void setConnection(Connection con)
   {
      this.con = con;
   }
   
   // TemporaryTopic implementation ---------------------------------

   public void delete() throws JMSException
   {
      try
      {
         con.deleteTemporaryDestination(this);
      }
      catch (Exception e)
      {
         throw new SpyJMSException("Cannot delete the TemporaryTopic", e);
      }
   }
   
   // Package protected ---------------------------------------------
   
   // Protected -----------------------------------------------------
   
   // Private -------------------------------------------------------
   
   // Inner classes -------------------------------------------------
}