/*
 * JBossMQ, the OpenSource JMS implementation
 * 
 * Distributable under LGPL license. See terms of license at gnu.org.
 */
package org.jboss.mq;

import java.io.Serializable;
import java.util.Enumeration;

import javax.jms.JMSException;
import javax.jms.Message;

/**
 * This Message class is used to send a non 'provider-optimized Message' over
 * the network [4.4.5]
 * 
 * @author Norbert Lataille (Norbert.Lataille@m4x.org)
 * @author Hiram Chirino (Cojonudo14@hotmail.com)
 * @author <a href="mailto:adrian@jboss.org">Adrian Brock</a>
 * @version $Revision:1$
 */
public class SpyEncapsulatedMessage extends SpyObjectMessage
{
   // Constants -----------------------------------------------------
   
   /** The serialVersionUID */
   private final static long serialVersionUID = 3995327252678969050L;
   
   // Attributes ----------------------------------------------------
   
   // Static --------------------------------------------------------
   
   // Constructors --------------------------------------------------
   
   // Public --------------------------------------------------------
   
   // SpyMessage overrides ------------------------------------------
   
   public void setMessage(Message m) throws JMSException
   {
      this.setObject((Serializable) m);

      if (m.getJMSCorrelationID() != null)
         setJMSCorrelationID(m.getJMSCorrelationID());
      else if (m.getJMSCorrelationIDAsBytes() != null)
         setJMSCorrelationIDAsBytes(m.getJMSCorrelationIDAsBytes());
      setJMSReplyTo(m.getJMSReplyTo());
      setJMSType(m.getJMSType());
      setJMSDestination(m.getJMSDestination());
      setJMSDeliveryMode(m.getJMSDeliveryMode());
      setJMSExpiration(m.getJMSExpiration());
      setJMSPriority(m.getJMSPriority());
      setJMSMessageID(m.getJMSMessageID());
      setJMSTimestamp(m.getJMSTimestamp());

      Enumeration enumeration = m.getPropertyNames();
      while (enumeration.hasMoreElements())
      {
         String name = (String) enumeration.nextElement();
         Object o = m.getObjectProperty(name);
         setObjectProperty(name, o);
      }
   }

   public Message getMessage() throws JMSException
   {
      Message m = (Message) this.getObject();
      m.setJMSRedelivered(getJMSRedelivered());
      return m;
   }
   
   // SpyMessage overrides ------------------------------------------
   
   public SpyMessage myClone() throws JMSException
   {
      SpyEncapsulatedMessage result = MessagePool.getEncapsulatedMessage();
      result.copyProps(this);
      //HACK to get around read only problem
      boolean readOnly = result.header.msgReadOnly;
      result.header.msgReadOnly = false;
      result.setMessage(this.getMessage());
      result.header.msgReadOnly = readOnly;
      return result;
   }
   
   // Package protected ---------------------------------------------
   
   // Protected -----------------------------------------------------
   
   // Private -------------------------------------------------------
   
   // Inner classes -------------------------------------------------
}