/*
 * JBossMQ, the OpenSource JMS implementation
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.mq;

/**
 *	This class provides a pool of SpyMessages.
 *
 * This is an very simple implementation first up.
 *
 *	@author David Maplesden (David.Maplesden@orion.co.nz)
 * @author <a href="mailto:adrian@jboss.org">Adrian Brock</a>
 * @version $Revision:1$
 */
public class MessagePool
{
   // Constants -----------------------------------------------------
   
   // Attributes ----------------------------------------------------
   
   // Static --------------------------------------------------------
   
   /**
    * Gets a message
    * 
    * @return a message
    */
   public static SpyMessage getMessage()
   {
      return new SpyMessage();
   }

   /**
    * Gets a bytes message.
    * 
    * @return a bytes message
    */
   public static SpyBytesMessage getBytesMessage()
   {
      return new SpyBytesMessage();
   }

   /**
    * Gets a map message
    * 
    * @return a map message
    */
   public static SpyMapMessage getMapMessage()
   {
      return new SpyMapMessage();
   }

   /**
    * Gets a stream message.
    * 
    * @return a stream message 
    */
   public static SpyStreamMessage getStreamMessage()
   {
      return new SpyStreamMessage();
   }

   /**
    * Gets an object message.
    * 
    * @return an object message
    */
   public static SpyObjectMessage getObjectMessage()
   {
      return new SpyObjectMessage();
   }

   /**
    * Gets a text message.
    */
   public static SpyTextMessage getTextMessage()
   {
      return new SpyTextMessage();
   }

   /**
    * Gets a encapsulated message.
    */
   public static SpyEncapsulatedMessage getEncapsulatedMessage()
   {
      return new SpyEncapsulatedMessage();
   }

   /**
    * Releases a SpyMessage.
    */
   public static void releaseMessage(SpyMessage message)
   {
      // Pooling is no longer used
   }
   
   // Constructors --------------------------------------------------
   
   // Public --------------------------------------------------------
   
   // Package protected ---------------------------------------------
   
   // Protected -----------------------------------------------------
   
   // Private -------------------------------------------------------
   
   // Inner classes -------------------------------------------------
}