/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

package org.jboss.media.util.registry;

import java.util.Iterator;

/**
 * A registry.
 *
 * @version <tt>$Revision:1$</tt>
 * @author <a href="mailto:ricardoarguello@users.sourceforge.net">Ricardo Argello</a>
 */
public interface Registry
{
   /**
    * Binds the given key with the given value.
    *
    * @param key.
    * @param value.
    * @throws ObjectAlreadyBoundException if there is another value 
    *          already bound for that key.
    */
   public void bind(Object key, Object value)
      throws ObjectAlreadyBoundException;

   /**
    * Rebinds the given key with the given value.
    *
    * @param key.
    * @param value.
    */
   public void rebind(Object key, Object value);

   /**
    * Unbinds a value with the given key.
    *
    * @param key.
    * @return value unbound.
    * @throws ObjectNotBoundException if there is no value bound to the key.
    */
   public Object unbind(Object key) throws ObjectNotBoundException;

   /**
    * Lookups a value with the given key.
    *
    * @param key.
    * @return value obtained.
    * @throws ObjectNotBoundException if there is no value bound to the key.
    */
   public Object lookup(Object key) throws ObjectNotBoundException;

   /**
    * Obtains an <code>Iterator</code> for all the keys in the registry.
    *
    * @return keys iterator.
    */
   public Iterator keyIterator();
}
