/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

package org.jboss.media.registry;

import java.util.Iterator;
import java.util.Map;

import javax.emb.FormatAlreadyBoundException;
import javax.emb.FormatNotFoundException;
import javax.emb.MediaFormat;

import org.jboss.media.util.registry.MapRegistry;
import org.jboss.media.util.registry.ObjectAlreadyBoundException;
import org.jboss.media.util.registry.ObjectNotBoundException;
import org.jboss.media.util.registry.Registry;

/**
 * A simple implementation of a MediaFormat registry.
 *
 * @version <tt>$Revision:1$</tt>
 * @author <a href="mailto:ricardoarguello@users.sourceforge.net">Ricardo Argello</a>
 */
public class SimpleMediaFormatRegistry
{
   private final Registry registry;

   public SimpleMediaFormatRegistry()
   {
      registry = new MapRegistry();
   }

   public SimpleMediaFormatRegistry(Map initialEntries)
      throws FormatAlreadyBoundException
   {
      try
      {
         registry = new MapRegistry(initialEntries);
      }
      catch (ObjectAlreadyBoundException e)
      {
         throw new FormatAlreadyBoundException();
      }
   }

   public void bind(String fileExtension, MediaFormat mediaFormat)
      throws FormatAlreadyBoundException
   {
      try
      {
         registry.bind(fileExtension, mediaFormat);
      }
      catch (ObjectAlreadyBoundException e)
      {
         throw new FormatAlreadyBoundException();
      }
   }

   public void rebind(String fileExtension, MediaFormat mediaFormat)
   {
      registry.rebind(fileExtension, mediaFormat);
   }

   public void unbind(String fileExtension) throws FormatNotFoundException
   {
      try
      {
         registry.unbind(fileExtension);
      }
      catch (ObjectNotBoundException e)
      {
         throw new FormatNotFoundException();
      }
   }

   public MediaFormat lookup(String fileExtension)
      throws FormatNotFoundException
   {
      try
      {
         return (MediaFormat) registry.lookup(fileExtension);
      }
      catch (ObjectNotBoundException e)
      {
         throw new FormatNotFoundException();
      }
   }

   public Iterator fileExtensions()
   {
      return registry.keyIterator();
   }
}
