/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

package org.jboss.media.format.image.iio;

import javax.emb.MediaHeader;
import javax.imageio.metadata.IIOMetadata;

import org.jboss.media.util.DOMUtils;
import org.w3c.dom.Node;

/**
 * Java Image I/O API generic implementation of the <code>MediaHeader</code> 
 * interface.
 *
 * @version <tt>$Revision:1$</tt>
 * @author <a href="mailto:ricardoarguello@users.sourceforge.net">Ricardo Argello</a>
 */
public abstract class IIOMediaHeader implements MediaHeader
{
   protected IIOMetadata imageMetadata;
   protected Node metadataRootNode;

   /**
    * Constructor.
    *
    * @param imageMetadata
    * @param formatName
    */
   public IIOMediaHeader(IIOMetadata imageMetadata, String formatName)
   {
      this.imageMetadata = imageMetadata;
      this.metadataRootNode = imageMetadata.getAsTree(formatName);
   }

   /**
    * @see javax.emb.MediaHeader#getFieldNames()
    */
   public abstract String[] getFieldNames();

   /**
    * @see javax.emb.MediaHeader#getField(java.lang.String)
    */
   public abstract Object getField(String fieldname);

   protected Node getNode(String node)
   {
      return getNode(metadataRootNode, node);
   }

   protected Node getNode(Node parentNode, String node)
   {
      return DOMUtils.findNode(parentNode, node);
   }

   protected String getAttribute(String node, String attribute)
   {
      return getAttribute(getNode(node), attribute);
   }

   protected String getAttribute(Node node, String attribute)
   {
      return DOMUtils.getNodeAttribute(node, attribute);
   }
}
