/*
 * JBoss, the OpenSource J2EE webOS
 * 
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

package org.jboss.media.format.audio.mpeg;

import java.io.InputStream;
import java.net.URL;

import javax.emb.Media;
import javax.emb.MediaException;
import javax.emb.MediaFormat;
import javax.emb.MediaHeader;
import javax.emb.MediaSegment;

import org.jboss.media.format.audio.AudioMediaFormat;

/**
 * Represents MPEG Audio formats (Layers I,II and III).
 * 
 * <p>A representation of an MPEG Audio format.
 * 
 * @version <tt>$Revision 1.1 $</tt>
 * @author <a href="mailto:ogreen@users.sourceforge.net">Owen Green</a>
 */
public class MpegAudioFormat extends AudioMediaFormat implements MediaFormat
{
   /**
    * @see javax.emb.MediaFormat#assembleContent(URL, MediaSegment[])
    */
   public byte[] assembleContent(
      URL mediaLocation,
      MediaSegment[] mediaSegments)
      throws MediaException
   {
      return null;
   }

   /**
    * @see javax.emb.MediaFormat#disassembleContent(URL, byte[])
    */
   public MediaSegment[] disassembleContent(
      URL mediaLocation,
      byte[] mediaContent)
      throws MediaException
   {
      return null;
   }

   /**
    * @see javax.emb.MediaFormat#extractHeader(InputStream)
    */
   public MediaHeader extractHeader(InputStream content) throws MediaException
   {
      if (null == content)
      {
         throw new NullPointerException();
      }
      return new MpegAudioHeader(content);
   }

   /**
    * @see javax.emb.MediaFormat#extractProxy(InputStream)
    */
   public Media extractProxy(InputStream content) throws MediaException
   {
      // TODO: Create a generic proxy
      return null;
   }

   /**
    * @see javax.emb.MediaFormat#getDefaultMimeType()
    */
   public String getDefaultMimeType()
   {
      return "audio/mpeg";
   }

   /**
    * @see javax.emb.MediaFormat#isEmbedded()
    */
   public boolean isEmbedded()
   {
      return false;
   }

   /**
    * @see javax.emb.MediaFormat#isStreamingDesirable()
    */
   public boolean isStreamingDesirable()
   {
      return false;
   }

   /**
    * Enumeration of possible versions for MPEG Audio
    */
   public static class Version
   {
      /**
      * MPEG Version 1(ISO/IEC 11172-3)
      */
      public final static Version MPEG1 = new Version("MPEG v1");

      /**
      * MPEG Version 2(ISO/IEC 13818-3)
      */
      public final static Version MPEG2 = new Version("MPEG v2");

      /**
      * MPEG Version 2.5 (recent extension to MPEG 2)
      */
      public final static Version MPEG25 = new Version("MPEG v2.5");

      private final String description;

      private Version(String description)
      {
         this.description = description;
      }

      /**
      * Returns a string description of this MPEG version indentifier
      * 
      * @return a string description of this MPEG version indentifier
      */
      public String toString()
      {
         return description;
      }
   }

   /**
    * Enumerates the possible layers for MPEG audio.
    */
   public static class Layer
   {
      /**
      * MPEG Audio Layer I
      */
      public static final Layer LAYERI = new Layer("Layer I");

      /**
      * MPEG Audio Layer II
      */
      public static final Layer LAYERII = new Layer("Layer II");

      /**
      * MPEG Audio Layer III
      */
      public static final Layer LAYERIII = new Layer("Layer III");

      private final String description;

      private Layer(String description)
      {
         this.description = description;
      }

      /**
      * Returns a string description of this MPEG layer indentifier
      * 
      * @return a string description of this MPEG layer indentifier
      */
      public String toString()
      {
         return description;
      }
   }

   /**
    * Enumerates the possible Channel Modes in MPEG Audio
    */
   public static class ChannelMode
   {
      public static final ChannelMode STEREO = new ChannelMode("Stereo");
      public static final ChannelMode JOINT_STEREO =
         new ChannelMode("Joint Stereo");
      public static final ChannelMode DUAL_CHANNEL =
         new ChannelMode("Dual Channel");
      public static final ChannelMode SINGLE_CHANNEL = new ChannelMode("Mono");

      private final String description;

      private ChannelMode(String description)
      {
         this.description = description;
      }

      /**
      * Returns a string description of this channel mode
      * 
      * @return a string description of this channel mode
      */
      public String toString()
      {
         return description;
      }
   }
}