/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.media.exampleplugins;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;

import org.jboss.media.engine.image.ImagePluginSupport;

/**
 * @version <tt>$Revision:1$</tt>
 * @author <a href="mailto:spyridon_samothrakis@yahoo.com">Spyridon Samothrakis</a>
 */
public class AddImageBordersPlugin extends ImagePluginSupport
{

   /* (non-Javadoc)
    * @see org.jboss.media.engine.image.ImagePluginSupport#processImage(org.jboss.media.engine.image.BufferedImageHolder)
    */
   public void processImage(BufferedImage image)
   {
      
      Rectangle[] rec = new Rectangle[3];
      rec[0] = new Rectangle(0, 0, image.getWidth()-1, image.getHeight()-1);
      rec[1] = new Rectangle(1, 1, image.getWidth()-2, image.getHeight()-2);
      rec[2] = new Rectangle(2, 2, image.getWidth()-3, image.getHeight()-3);
      drawRectangles(rec,image);
   }

   private BufferedImage drawRectangles(Rectangle[] rec, BufferedImage img)
   {
      for (int i = 0; i < rec.length; i++)
      {
         img =
            drawRectangle(
               (int) rec[i].getX(),
               (int) rec[i].getY(),
               (int) rec[i].getWidth(),
               (int) rec[i].getHeight(),
               img);
      }

      return img;
   }

   private BufferedImage drawRectangle(
      int x0,
      int y0,
      int x1,
      int y1,
      BufferedImage img)
   {

      if (y1 > img.getHeight() || x1 > img.getWidth())
         return img;
      if (y0 > img.getHeight() || x0 > img.getWidth())
         return img;

      int temp = x0;
      while (temp < x1 && temp < img.getWidth())
      {
         // System.out.println(temp);
         // System.out.println(y0);
         // System.out.println(y1);
         img.setRGB(temp, y0, Color.green.getRGB());
         img.setRGB(temp, y1, Color.green.getRGB());
         temp++;

      }

      temp = y0;
      while (temp < y1 && temp < img.getHeight())
      {
         //System.out.println(temp);
         // System.out.println(x0);
         // System.out.println(x1);
         img.setRGB(x0, temp, Color.green.getRGB());
         img.setRGB(x1, temp, Color.green.getRGB());
         temp++;

      }

      return img;
   }

}
