/*
 * JBoss, the OpenSource J2EE webOS
 * 
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

package org.jboss.media.entity;

import java.io.Serializable;
import java.net.URL;

/**
 * Data Transfer Object for an EntityMediaLocal object.
 * 
 * @version <tt>$Revision:1$</tt>
 * @author <a href="mailto:ricardoarguello@users.sourceforge.net">Ricardo Argello</a>
 */
public class MediaEntityDTO implements Serializable
{
   private byte[] content;
   private URL location;
   private String description;
   private String name;
   private String mimeType;

   /**
    * Default constructor.
    */
   public MediaEntityDTO()
   {
   }

   /**
    * Constructor with all properties.
    * 
    * @param content content.
    * @param location location.
    * @param description description.
    * @param name name.
    * @param mimeType MIME type.
    */
   public MediaEntityDTO(
      byte[] content,
      URL location,
      String description,
      String name,
      String mimeType)
   {
      this.content = content;
      this.location = location;
      this.description = description;
      this.name = name;
      this.mimeType = mimeType;
   }

   /**
    * @return Returns the content.
    */
   public byte[] getContent()
   {
      return content;
   }

   /**
    * @param content The content to set.
    */
   public void setContent(byte[] content)
   {
      this.content = content;
   }

   /**
    * @return Returns the description.
    */
   public String getDescription()
   {
      return description;
   }

   /**
    * @param description The description to set.
    */
   public void setDescription(String description)
   {
      this.description = description;
   }

   /**
    * @return Returns the location.
    */
   public URL getLocation()
   {
      return location;
   }

   /**
    * @param location The location to set.
    */
   public void setLocation(URL location)
   {
      this.location = location;
   }

   /**
    * @return Returns the mimeType.
    */
   public String getMimeType()
   {
      return mimeType;
   }

   /**
    * @param mimeType The mimeType to set.
    */
   public void setMimeType(String mimeType)
   {
      this.mimeType = mimeType;
   }

   /**
    * @return Returns the name.
    */
   public String getName()
   {
      return name;
   }

   /**
    * @param name The name to set.
    */
   public void setName(String name)
   {
      this.name = name;
   }

   // TODO: Implement equals() and hash()
}