/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */


package org.jboss.media.engine;

import java.util.HashMap;
import java.util.Iterator;

import org.jboss.system.ServiceMBeanSupport;

/**
 * @version <tt>$Revision:1$</tt>
 * @author <a href="mailto:spyridon_samothrakis@yahoo.com">Spyridon Samothrakis</a>
 * @jmx.mbean extends="org.jboss.system.ServiceMBean"
 * @jmx.mbean description="The media registry"
 */
public class MediaRegistry
   extends ServiceMBeanSupport
      implements MediaRegistryMBean
{

   private HashMap m_media = new HashMap();
   
   /**
    * @jmx.managed-operation description="add a media object"
    */
   public void addMedia(String name , Media object)
   {
      m_media.put(name,object);
   }
   
   /**
    * @jmx.managed-operation description="remove a media object"
    */
   public void removeMedia(String name)
   {
      m_media.remove(name);
   }
   
   /**
    * @jmx.managed-operation description="get the list of transcoder"
    */
   public Iterator getMediaNames()
   {
      return ((HashMap)m_media.clone()).keySet().iterator();
   }
   
   
   /**
    * @jmx.managed-operation description="acquire a transcoder"
    */
   public Media getMedia(String name)
   {
      return (Media)m_media.get(name);
   }

}
