/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

package org.jboss.media.engine;

import javax.management.ObjectName;

import org.jboss.logging.Logger;

/**
 * @version <tt>$Revision:1$</tt>
 * @author <a href="mailto:spyridon_samothrakis@yahoo.com">Spyridon Samothrakis</a>
 * @jmx.mbean description="The basic abstract MediaPublisher"
 */
public abstract class MediaPublisher implements MediaPublisherMBean
{

   // Where are we ?
   private String m_host;
   // The number of the gate
   private int m_port;
   // and serve what ? 
   private String m_fileName;
   // where should I serve it?
   private String m_context;
   //which protocol to use ??
   private int m_protocolServer;
   // what's my name ? 
   private ObjectName m_name;

   ////////////////////////////////////////////////////////////////////////////

   protected Logger log = Logger.getLogger(getClass().getName());

   // Getters / Setters

   /**
    * Returns the context.
    * @return String
    * @jmx:managed-attribute
    */
   public String getContext()
   {
      return m_context;
   }

   /**
    * Returns the fileName.
    * @return String
    * @jmx:managed-attribute
    */
   public String getFileName()
   {
      return m_fileName;
   }

   /**
    * Returns the host.
    * @return String
    * @jmx:managed-attribute
    */
   public String getHost()
   {
      return m_host;
   }

   /**
    * Returns the port.
    * @return int
    * @jmx:managed-attribute
    */
   public int getPort()
   {
      return m_port;
   }

   /**
    * Sets the context.
    * @param context The context to set
    * @jmx:managed-attribute
    */
   public void setContext(String context)
   {
      m_context = context;
   }

   /**
    * Sets the fileName.
    * @param fileName The fileName to set
    * @jmx:managed-attribute
    */
   public void setFileName(String fileName)
   {
      m_fileName = fileName;
   }

   /**
    * Sets the host.
    * @param host The host to set
    * @jmx:managed-attribute
    */
   public void setHost(String host)
   {
      m_host = host;
   }

   /**
    * Sets the port.
    * @param port The port to set
    * @jmx:managed-attribute
    */
   public void setPort(int port)
   {
      m_port = port;
   }

   /**
    * @return
    * @jmx:managed-attribute
    */
   public ObjectName getName()
   {
      return m_name;
   }

   /**
    * @param name
    * @jmx:managed-attribute
    */
   public void setName(ObjectName name)
   {
      m_name = name;
   }

   /**
    * Publishes the processed media using a the specified protocol 
    * server
    * @jmx.managed-operation
    */
   public abstract void publish() throws Exception;

   /**
    * Stops publication of the current media
    * @jmx.managed-operation
    */
   public abstract void stop();
   
   /**
    * Stops publication of the current media
    * @jmx.managed-operation
    */
   public abstract void addPluginGraph(MediaPluginGraph pg);
   
   

}
