/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

package org.jboss.media.engine;

import java.util.HashMap;
import java.util.Iterator;

import org.jboss.logging.Logger;
import org.jboss.system.ServiceMBeanSupport;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * @version <tt>$Revision:1$</tt>
 * @author <a href="mailto:spyridon_samothrakis@yahoo.com">Spyridon Samothrakis</a>
 * @jmx.mbean extends="org.jboss.system.ServiceMBean"
 * @jmx.mbean description="The media engine plugin registry"
 */
public class MediaPluginRegistry
   extends ServiceMBeanSupport
   implements MediaPluginRegistryMBean
{
   private HashMap m_plugins = new HashMap();
   private Logger log = Logger.getLogger(getClass());
   private Element m_initialPlugins;

   /**
    * @jmx.managed-operation description="add a plugin"
    */
   public void addPlugin(String name, MediaPlugin object)
   {
      m_plugins.put(name, object);
      log.info(
         "adding plugin with name " + name + "of class " + object.getName());
   }

   /**
    * @jmx.managed-operation description="remove a plugin"
    */
   public void removePlugin(String name)
   {
      m_plugins.remove(name);
      log.info("removing plugin with name " + name);
   }

   /**
    * @jmx.managed-operation description="get the list of plugins"
    */
   public Iterator getPluginNames()
   {
      return ((HashMap) m_plugins.clone()).keySet().iterator();
   }

   /**
    * @jmx.managed-operation description="acquire a plugin"
    */
   public MediaPlugin getPlugin(String name)
   {
      return (MediaPlugin) m_plugins.get(name);
   }

   /**
    * @return
    * @jmx.managed-attribute
    */
   public Element getInitialPlugins()
   {
      return m_initialPlugins;
   }

   /**
    * @param element
    * @jmx.managed-attribute
    */
   public void setInitialPlugins(Element xml)
   {
      m_initialPlugins = xml;
      NodeList children = xml.getChildNodes();
      for (int i = 0; i < children.getLength(); i++)
      {
         if (children.item(i).getNodeType() == Node.ELEMENT_NODE)
         {
            Element element = (Element) children.item(i);
            String tag = element.getTagName();

           // if (tag.equals("plugin"))
           // {
               String name = element.getAttribute("name");
               String classname = element.getAttribute("class");
               try
               {
                  addPlugin(name, (MediaPlugin)Class.forName(classname).newInstance());
               }
               catch (InstantiationException e)
               {
                  log.error(e);
               }
               catch (IllegalAccessException e)
               {
                  log.error(e);
               }
               catch (ClassNotFoundException e)
               {
                  log.error("Could not find plugin with class " + classname);
               }
            //}
         }
      }
   }

}
