/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

package org.jboss.media.engine;

import java.io.File;
import java.net.URL;

import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;
import org.jboss.deployment.DeploymentException;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.deployment.SubDeployer;
import org.jboss.deployment.SubDeployerSupport;

/**
 * @version <tt>$Revision:1$</tt>
 * @author <a href="mailto:spyridon_samothrakis@yahoo.com">Spyridon Samothrakis</a>
 *
 * @jmx:mbean extends="org.jboss.deployment.SubDeployerMBean"
 */
public class MediaEngineDeployer
   extends SubDeployerSupport
   implements SubDeployer, MediaEngineDeployerMBean
{
   public MediaEngineDeployer()
   {
   }

   /**
    * @see org.jboss.deployment.SubDeployerMBean#accepts(DeploymentInfo)
    */
   public boolean accepts(DeploymentInfo info)
   {

      String urlStr = info.url.toString();
      return (urlStr.endsWith("-media.xml"));
   }

   protected boolean isDeployable(String name, URL url)
   {
      return (name.endsWith("-media.xml"));
   }

   public void init(DeploymentInfo di) throws DeploymentException
   {
      //default action on duplicate deployment is to ignore this one.
      super.init(di);

      boolean debug = log.isDebugEnabled();

      try
      {
         if (di.watch == null)
         {
            // resolve the watch
            if (di.url.getProtocol().equals("file"))
            {
               File file = new File(di.url.getFile());

               // If not directory we watch the package
               if (!file.isDirectory())
               {
                  di.watch = di.url;
               }
            }
            else
            {
               // We watch the top only, no directory support
               di.watch = di.url;
            }
         }
         // Get the document if not already present
         parseDocument(di);
      }
      catch (Exception e)
      {
         log.error("failed to parse media document: ", e);
         throw new DeploymentException(e);
      }
   }

   /**
    * @param di
    */
   private void parseDocument(DeploymentInfo di)
      throws DeploymentException, DocumentException
   {
      // Spy: Have a look at this:
      /*if (di.getDocument() == null)
      {
         //DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
         URL docURL = di.localUrl;
         // Load jboss-service.xml from the jar or directory
      
         if (docURL == null)
            throw new DeploymentException("Failed to initialize");
      
         SAXReader sr = new SAXReader();
         di.setDocument(sr.read(docURL));
      }
      else
      {
         log.debug("Using existing deployment.document");
      }*/

   }

   /* (non-Javadoc)
    * @see org.jboss.deployment.SubDeployerMBean#create(org.jboss.deployment.DeploymentInfo)
    */
   public synchronized void create(DeploymentInfo di)
      throws DeploymentException
   {

      super.create(di);
      log.info("Deploying *-media.xml descriptor");
   }

   /* (non-Javadoc)
    * @see org.jboss.deployment.SubDeployerMBean#start(org.jboss.deployment.DeploymentInfo)
    */
   public void start(DeploymentInfo di) throws DeploymentException
   {
      // Spy: Have a look at this:
      /*super.start(di);
      try
      {
         MediaXmlLoader.deployXML(
            di.getW3CDocument(),
            di.localUrl,
            getServer());
      }
      catch (Exception ex)
      {
         ex.printStackTrace();
         throw new DeploymentException(ex);
      }
      super.start(di);*/
   }

   /* (non-Javadoc)
    * @see org.jboss.deployment.SubDeployerMBean#stop(org.jboss.deployment.DeploymentInfo)
    */
   public synchronized void stop(DeploymentInfo di) throws DeploymentException
   {
      // Spy: Have a look at this:
      /*super.stop(di);
      try
      {
         MediaXmlLoader.undeploy(di.getW3CDocument(), di.localUrl, getServer());
      }
      catch (Exception ex)
      {
         ex.printStackTrace();
         throw new DeploymentException(ex);
      }
      super.start(di);*/
   }
}
