/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

package org.jboss.media.engine;

import java.util.Vector;

import javax.media.Buffer;
import javax.media.Control;
import javax.media.Effect;
import javax.media.Format;
import javax.media.ResourceUnavailableException;

/**
 * @version <tt>$Revision:1$</tt>
 * @author <a href="mailto:spyridon_samothrakis@yahoo.com">Spyridon Samothrakis</a>
 */
public abstract class JmfAbstractMediaPlugin implements Effect
{

   Vector m_mediaPlugins = new Vector();

   /**
    * @see javax.media.Codec#getSupportedInputFormats()
    */
   public Format[] getSupportedInputFormats()
   {
      return getSupportedFormats();
   }

   /**
    * @see javax.media.Codec#getSupportedOutputFormats(Format)
    */
   public Format[] getSupportedOutputFormats(Format in)
   {
      if (in == null)
         return getSupportedFormats();
      else
      {
         Format outs[] = new Format[1];
         outs[0] = in;
         return outs;

      }
   }

   /**
    * @see javax.media.Codec#process(Buffer, Buffer)
    */
   public int process(Buffer input, Buffer output)
   {
      // Swap the data between the input & output.

      output.setData(input.getData());

      // Copy the input attributes to the output
      output.setFormat(input.getFormat());
      output.setLength(input.getLength());
      output.setOffset(input.getOffset());

      // call the plugins

      for (int i = 0; i < m_mediaPlugins.size(); i++)
      {
         // process output
          ((MediaPlugin) m_mediaPlugins.elementAt(i)).process(output);
      }

      return BUFFER_PROCESSED_OK;
   }

   /**
    * @see javax.media.Codec#setInputFormat(Format)
    */
   public Format setInputFormat(Format format)
   {
      return format;
   }

   /**
    * @see javax.media.Codec#setOutputFormat(Format)
    */
   public Format setOutputFormat(Format format)
   {
      return format;
   }

   /**
    * @see javax.media.PlugIn#close()
    */
   public void close()
   {
   }

   /**
    * @see javax.media.PlugIn#getName()
    */
   public String getName()
   {
      return getClass().getName();
   }

   /**
    * @see javax.media.PlugIn#open()
    */
   public void open() throws ResourceUnavailableException
   {
   }

   /**
    * @see javax.media.PlugIn#reset()
    */
   public void reset()
   {
   }

   /**
    * @see javax.media.Controls#getControl(String)
    */
   public Object getControl(String arg0)
   {
      return null;
   }

   /**
    * @see javax.media.Controls#getControls()
    */
   public Object[] getControls()
   {
      return (Object[]) (new Control[0]);
   }

   /**
    * Method getSupportedFormats.
    * @return Format[] An array of the supported formats
    * for this plugin
    */
   public abstract Format[] getSupportedFormats();

   public void setPluginGraph(MediaPluginGraph graph)
   {
      m_mediaPlugins = graph.getPluginVector();
   }

   public Vector getPluginGraph()
   {
      return m_mediaPlugins;
   }
}
