/*
 * JBoss, the OpenSource J2EE webOS
 * 
 * Distributable under LGPL license. See terms of license at gnu.org.
 */

package javax.emb;

/**
 * This exception is thrown if no suitable protocol server is found during
 * publish operations.
 * 
 * @version <tt>$Revision:1$</tt>
 * @author <a href="mailto:ricardoarguello@users.sourceforge.net">Ricardo
 *         Argello</a>
 */
public class NoServerFoundException extends MediaException
{
   /**
    * @see javax.emb.MediaException()
    */
   public NoServerFoundException()
   {
      super();
   }

   /**
    * @see javax.emb.MediaException(String)
    */
   public NoServerFoundException(String message)
   {
      super(message);
   }

   /**
    * @see javax.emb.MediaException(String, Throwable)
    */
   public NoServerFoundException(String message, Throwable cause)
   {
      super(message, cause);
   }

   /**
    * @see javax.emb.MediaException(Throwable)
    */
   public NoServerFoundException(Throwable cause)
   {
      super(cause);
   }
}