/*
 * JBoss, the OpenSource J2EE webOS
 * 
 * Distributable under LGPL license. See terms of license at gnu.org.
 */

package javax.emb;

/**
 * This exception is thrown during <code>MetaDataEntityLocal.getXML()</code>
 * whenever the XML metadata given is not well formed.
 * 
 * @version <tt>$Revision:1$</tt>
 * @author <a href="mailto:ricardoarguello@users.sourceforge.net">Ricardo
 *         Argello</a>
 */
public class MetaDataSyntaxException extends MediaException
{
   /**
    * @see javax.emb.MediaException()
    */
   public MetaDataSyntaxException()
   {
      super();
   }

   /**
    * @see javax.emb.MediaException(String)
    */
   public MetaDataSyntaxException(String message)
   {
      super(message);
   }

   /**
    * @see javax.emb.MediaException(String, Throwable)
    */
   public MetaDataSyntaxException(String message, Throwable cause)
   {
      super(message, cause);
   }

   /**
    * @see javax.emb.MediaException(Throwable)
    */
   public MetaDataSyntaxException(Throwable cause)
   {
      super(cause);
   }
}