/*
 * JBoss, the OpenSource J2EE webOS
 * 
 * Distributable under LGPL license. See terms of license at gnu.org.
 */

package javax.emb;

import java.util.Collection;
import java.util.Map;

import javax.ejb.CreateException;
import javax.ejb.EJBLocalHome;
import javax.ejb.FinderException;

/**
 * This interface defines the local home interface of metadata entity EJBs and
 * therefore services relevant for local, persistent and mutable metadata
 * objects. It extends javax.ejb.EJBLocalHome and defines additional methods
 * with a semantic requiring the persistence of such metadata
 * 
 * @version <tt>$Revision:1$</tt>
 * @author <a href="mailto:ricardoarguello@users.sourceforge.net">Ricardo
 *         Argello</a>
 */
public interface MetaDataEntityLocalHome extends EJBLocalHome
{
   /**
    * Creates a new metadata entity EJB with a generated identity key, null XML
    * content and default values for the other properties. Please note many of
    * the Metadata Entity EJB methods will throw exceptions until the XML
    * content is set.
    * 
    * @return metadata entity.
    * @throws javax.ejb.CreateException if a problem related to EJB creation
    *         occurs.
    * @throws MediaException
    */
   MetaDataEntityLocal create() throws CreateException, MediaException;

   /**
    * Returns the metadata entity with the given identity.
    * 
    * @param identity.
    * @return metadata entity.
    * @throws java.lang.NullPointerException if the value passed is <code>null</code>.
    * @throws javax.ejb.FinderException if no matching metadata entity is
    *         found.
    */
   MetaDataEntityLocal findByPrimaryKey(String identity)
      throws FinderException;

   /**
    * Returns the metadata entities that match the given query. The query
    * semantics are defined by the given query language in association with the
    * optionally given query options. Note that the set of query languages and
    * options supported is up to the implementation. Valid keys for the options
    * map can be derived by calling <code>retrieveSupportedOptions()</code>.
    * In case unsupported options are passed, implementations should ignore
    * them.
    * 
    * @param query
    * @param queryLanguage
    * @param options
    * @return collection.
    * @throws java.lang.NullPointerException if the query or query language
    *         passed is <code>null</code>.
    * @throws java.lang.NullPointerException if the query or query language
    *         passed is null.
    * @throws javax.emb.MalformedQueryException if the query statement does not
    *         match the syntax defined by the given query language.
    * @throws javax.emb.UnsupportedQueryLanguageException if the specified
    *         query language is not supported by the implementation.
    * @throws javax.emb.IllegalOptionException if the given options are not
    *         formatted properly and cannot be read or if one of the options is
    *         unsupported and cannot be processed.
    * @throws javax.emb.MalformedQueryException if the query statement does not
    *         match the syntax defined by the given query language.
    * @throws javax.emb.UnsupportedQueryLanguageException if the specified
    *         query language is not supported by the implementation.
    * @throws javax.emb.IllegalOptionException if the given options are not
    *         formatted properly and cannot be read or if one of the options is
    *         unsupported and cannot be processed.
    */
   Collection query(String query, String queryLanguage, Map options)
      throws FinderException, MediaException;

   /**
    * Returns an array containing the names of supported options for the given
    * query language. If no query options are supported then an empty array is
    * returned.
    * 
    * @param queryLanguage
    * @return @throws java.lang.NullPointerException if the value passed is
    *         <code>null</code>.
    * @throws javax.emb.UnsupportedQueryLanguageException if the name of the
    *         query language passed is not supported by the implementation.
    */
   String[] retrieveSupportedOptions(String queryLanguage)
      throws MediaException;

   /**
    * Returns an array containing the names of supported query languages. If no
    * query languages are supported then an empty array is returned.
    * 
    * @return @throws MediaException
    */
   String[] retrieveSupportedQueryLanguages() throws MediaException;
}