/*
 * JBoss, the OpenSource J2EE webOS
 * 
 * Distributable under LGPL license. See terms of license at gnu.org.
 */

package javax.emb;

/**
 * This exception is thrown whenever a problem occurs in dealing with a media
 * format. Usually, this exception is not thrown directly. Instead, instances
 * of its subclasses are thrown to indicate a more specific reason for the
 * problem.
 * 
 * @version <tt>$Revision:1$</tt>
 * @author <a href="mailto:ricardoarguello@users.sourceforge.net">Ricardo
 *         Argello</a>
 */
public class MediaFormatException extends MediaException
{
   /**
    * @see javax.emb.MediaException()
    */
   public MediaFormatException()
   {
      super();
   }

   /**
    * @see javax.emb.MediaException(String)
    */
   public MediaFormatException(String message)
   {
      super(message);
   }

   /**
    * @see javax.emb.MediaException(String, Throwable)
    */
   public MediaFormatException(String message, Throwable cause)
   {
      super(message, cause);
   }

   /**
    * @see javax.emb.MediaException(Throwable)
    */
   public MediaFormatException(Throwable cause)
   {
      super(cause);
   }
}