/*
 * JBoss, the OpenSource J2EE webOS
 * 
 * Distributable under LGPL license. See terms of license at gnu.org.
 */

package javax.emb;

import java.io.Serializable;

/**
 * An instance of a class implementing this interface collects all properties
 * necessary to perform a conversion from a specific source format to a
 * specific target format. One or more converter spec classes correspond to one
 * converter class, and the contract for accessing the conversion parameters is
 * up to the implementers of the converter spec classes.
 * 
 * <p>A conversion spec instance can be reused for multiple conversions. Also,
 * implementations of this interface must provide a default constructor that
 * initializes all properties with suitable values, in order to allow default
 * conversions. As converter specs sometimes have to be transferred over
 * machine boundaries, this interface extends {@link java.io.Serializable}.
 * The design allows various parties to come up with implementations for
 * various combinations of media formats.
 * 
 * @version <tt>$Revision:1$</tt>
 * @author <a href="mailto:ricardoarguello@users.sourceforge.net">Ricardo
 *         Argello</a>
 */
public interface MediaConverterSpec extends Serializable
{
   /**
    * Returns an object implementing the {@link MediaConverter}interface that
    * can be used to process conversions using the receiver. The instance
    * returned is initialized with the receiver to define the conversion
    * specific parameters.
    * 
    * @return the media converter.
    * @throws MediaException if the instantiation of the converter fails.
    */
   MediaConverter getConverter() throws MediaException;

   /**
    * Returns a MIME type as a String that can be used as a default for media
    * objects created using the receiver. A result of <code>null</code>
    * indicates that the receiver does not alter the media format of the
    * content offered on the given input stream.
    * 
    * @return the target MIME type.
    */
   String getTargetMimeType();

   /**
    * Returns a file extension as a String that can be used as a default for
    * media objects created using the receiver. The String must not include any
    * separator characters. A result of <code>null</code> indicates that the
    * receiver does not alter the media format of the content offered on the
    * given input stream.
    * 
    * @return the target file extension.
    */
   String getTargetFileExtension();
}