/*
* JBoss, the OpenSource J2EE webOS
*
* Distributable under LGPL license.
* See terms of license at gnu.org.
*/
package org.jboss.management.j2ee.statistics;

import org.jboss.management.j2ee.StatisticsConstants;

import javax.management.j2ee.statistics.JCAConnectionStats;
import javax.management.j2ee.statistics.TimeStatistic;

/**
 * @author Scott.Stark@jboss.org
 * @version $Revision:1$
 */
public class JCAConnectionStatsImpl extends StatsBase
        implements JCAConnectionStats
{
   // Constants -----------------------------------------------------
   
   /** @since 4.0.2 */
   private static final long serialVersionUID = -5409299496765142153L;

   // Private Data --------------------------------------------------
   
   private String cfName;
   private String mcfName;

   // Constructors --------------------------------------------------
      
   public JCAConnectionStatsImpl(String cfName, String mcfName)
   {
      this(cfName, mcfName, null, null);
   }

   public JCAConnectionStatsImpl(String cfName, String mcfName,
                                 TimeStatistic waitTime, TimeStatistic useTime)
   {
      if (waitTime == null)
      {
         waitTime = new TimeStatisticImpl("WaitTime", StatisticsConstants.MILLISECOND,
                 "Time spent waiting for a connection to be available");
      }
      if (useTime == null)
      {
         useTime = new TimeStatisticImpl("UseTime", StatisticsConstants.MILLISECOND,
                 "Time spent using the connection");
      }
      super.addStatistic("WaitTime", waitTime);
      super.addStatistic("UseTime", useTime);
      this.cfName = cfName;
      this.mcfName = mcfName;
   }

   public String getConnectionFactory()
   {
      return cfName;
   }

   public String getManagedConnectionFactory()
   {
      return mcfName;
   }

   public TimeStatistic getWaitTime()
   {
      TimeStatistic ts = (TimeStatistic) getStatistic("WaitTime");
      return ts;
   }

   public TimeStatistic getUseTime()
   {
      TimeStatistic ts = (TimeStatistic) getStatistic("UseTime");
      return ts;
   }
}
