/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.management.j2ee;

import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * Root class of the JBoss JSR-77 implementation of
 * {@link javax.management.j2ee.J2EEModule J2EEModule}.
 *
 * @author <a href="mailto:andreas@jboss.org">Andreas Schaefer</a>.
 * @author thomas.diesler@jboss.org
 * @version $Revision:1$
 * @jmx:mbean extends="org.jboss.management.j2ee.J2EEDeployedObjectMBean"
 */
public abstract class J2EEModule
        extends J2EEDeployedObject
        implements J2EEModuleMBean
{
   // Attributes ----------------------------------------------------

   // list of object names as strings
   private List mJVMs = new ArrayList();

   // Constructors --------------------------------------------------

   /**
    * Constructor taking the Name of this Object
    *
    * @param pName                 Name to be set which must not be null
    * @param pParent               Object Name of its parent which can either
    *                              be a J2EEApplication or J2EEServer if a
    *                              standalone module (not packed into an EAR file)
    * @param pDeploymentDescriptor
    * @throws InvalidParameterException If the given Name is null
    */
   public J2EEModule(String pType,
                     String pName,
                     ObjectName pParent,
                     String[] pJVMs,
                     String pDeploymentDescriptor)
           throws
           MalformedObjectNameException,
           InvalidParentException
   {
      super(pType, pName, pParent, pDeploymentDescriptor);
      mJVMs = new ArrayList(Arrays.asList(pJVMs == null ? new String[0] : pJVMs));
   }

   // Public --------------------------------------------------------

   /**
    * @jmx:managed-attribute
    */
   public String[] getjavaVMs()
   {
      return (String[]) mJVMs.toArray(new String[mJVMs.size()]);
   }

   /**
    * @jmx:managed-operation
    */
   public String getjavaVM(int pIndex)
   {
      if (pIndex >= 0 && pIndex < mJVMs.size())
      {
         return (String) mJVMs.get(pIndex);
      }
      else
      {
         return null;
      }
   }
}
