/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.management.j2ee;

import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import java.util.ArrayList;
import java.util.List;

/**
 * Root class of the JBoss JSR-77 implementation of
 * {@link javax.management.j2ee.J2EEDomain J2EEDomain}.
 *
 * @author <a href="mailto:andreas@jboss.org">Andreas Schaefer</a>.
 * @author thomas.diesler@jboss.org
 * @version $Revision:1$
 * @jmx:mbean description="sample for jboss xmbean.dtd"
 * persistPolicy="Never"
 * persistPeriod="10"
 * persistLocation="pl1"
 * persistName="JBossXMLExample1"
 * currencyTimeLimit="10"
 * descriptor="name=\"testdescriptor\" value=\"testvalue\""
 * state-action-on-update="RESTART"
 * <p/>
 * <p><b>Revisions:</b>
 * <p/>
 * <p><b>20011126 Andreas Schaefer:</b>
 * <ul>
 * <li> Adjustments to the JBoss Guidelines
 * </ul>
 * <p/>
 * <p><b>20020304 Andreas Schaefer:</b>
 * <ul>
 * <li> Moved to XMBean
 * </ul>
 */
public class J2EEDomainTarget
        extends J2EEManagedObject
//   implements J2EEDomainTargetMBean
{
   // -------------------------------------------------------------------------
   // Members
   // -------------------------------------------------------------------------
   
   private List mServers = new ArrayList();
   
   // -------------------------------------------------------------------------
   // Constructors
   // -------------------------------------------------------------------------
   
   /**
    * @jmx:managed-constructor
    */
   public J2EEDomainTarget(String pDomainName)
           throws
           MalformedObjectNameException,
           InvalidParentException
   {
      super(pDomainName, "J2EEDomain", "Manager");
   }
   
   // -------------------------------------------------------------------------
   // Properties (Getters/Setters)
   // -------------------------------------------------------------------------
   
   /**
    * @jmx:managed-attribute description="List of all Servers on this Managment Domain"
    * access="READ"
    * persistPolicy="Never"
    * persistPeriod="30"
    * currencyTimeLimit="30"
    */
   public String[] getservers()
   {
      return (String[]) mServers.toArray(new String[mServers.size()]);
   }

   /**
    * @jmx:managed-operation description="Returns the requested Server" impact="INFO"
    */
   public String getserver(int pIndex)
   {
      if (pIndex >= 0 && pIndex < mServers.size())
      {
         return (String) mServers.get(pIndex);
      }
      return null;
   }

   public String toString()
   {
      return "J2EEDomainTarget { " + super.toString() + " } [ " +
              ", servers: " + mServers +
              " ]";
   }

   /**
    * @jmx:managed-operation description="adds a new child of this Management Domain" impact="INFO"
    */
   public void addChild(ObjectName pChild)
   {
      String lType = J2EEManagedObject.getType(pChild);
      if (J2EETypeConstants.J2EEServer.equals(lType))
      {
         mServers.add(pChild.getCanonicalName());
      }
   }

   /**
    * @jmx:managed-operation description="removes a new child of this Management Domain" impact="ACTION"
    */
   public void removeChild(ObjectName pChild)
   {
      String lType = J2EEManagedObject.getType(pChild);
      if (J2EETypeConstants.J2EEServer.equals(lType))
      {
         mServers.remove(pChild.getCanonicalName());
      }
   }
}
