/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.management.j2ee;

import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import java.security.InvalidParameterException;
import java.util.Hashtable;

/**
 * Root class of the JBoss JSR-77 implementation of
 * {@link javax.management.j2ee.AppClientModule AppClientModule}.
 *
 * @author <a href="mailto:andreas@jboss.org">Andreas Schaefer</a>.
 * @author thomas.diesler@jboss.org
 * @version $Revision:1$
 *          <p/>
 *          <p><b>Revisions:</b>
 *          <p/>
 *          <p><b>20020307 Andreas Schaefer:</b>
 *          <ul>
 *          <li> Creation
 *          </ul>
 * @jmx:mbean extends="org.jboss.management.j2ee.J2EEModuleMBean"
 */
public class AppClientModule
        extends J2EEModule
        implements AppClientModuleMBean
{

   // Constants -----------------------------------------------------

   // Attributes ----------------------------------------------------
   
   // Static --------------------------------------------------------
   
   // Constructors --------------------------------------------------
   
   /**
    * Constructor taking the Name of this Object
    *
    * @param pName                 Name to be set which must not be null
    * @param pDeploymentDescriptor
    * @throws InvalidParameterException If the given Name is null
    */
   public AppClientModule(String pName, ObjectName pApplication, String[] pJVMs, String pDeploymentDescriptor)
           throws
           MalformedObjectNameException,
           InvalidParentException
   {
      super(J2EETypeConstants.AppClientModule, pName, pApplication, pJVMs, pDeploymentDescriptor);
   }
   
   // Public --------------------------------------------------------
   
   // Object overrides ---------------------------------------------------
   
   public String toString()
   {
      return "AppClientModule { " + super.toString() +
              " } []";
   }
   
   // Package protected ---------------------------------------------
   
   // Protected -----------------------------------------------------
   
   /**
    * @return A hashtable with the J2EE-Application and J2EE-Server as parent
    */
   protected Hashtable getParentKeys(ObjectName pParent)
   {
      Hashtable lReturn = new Hashtable();
      Hashtable lProperties = pParent.getKeyPropertyList();
      lReturn.put(J2EETypeConstants.J2EEApplication, lProperties.get("name"));
      // J2EE-Server is already parent of J2EE-Application therefore lookup
      // the name by the J2EE-Server type
      lReturn.put(J2EETypeConstants.J2EEServer, lProperties.get(J2EETypeConstants.J2EEServer));

      return lReturn;
   }
   
   // Private -------------------------------------------------------
   
   // Inner classes -------------------------------------------------

}
