/**
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package javax.management.j2ee.statistics;

// $Id:Statistic.java,v 1.0, 2005-06-24 19:17:01Z, Robert Worsnop$


/**
 * The Statistic model and its sub-models specify the data models which are requried to be used to provide the performance
 * data described by the specific attributes in the Stats models.
 * 
 * @author thomas.diesler@jboss.org
 */
public interface Statistic
{
   /**
    * The name of this Statistic.
    */
   public String getName();

   /**
    * The unit of measurement for this Statistic. Valid values for TimeStatistic measurements are "HOUR", "MINUTE", "SECOND", "MILLISECOND", "MICROSECOND" and "NANOSECOND".
    */
   public String getUnit();

   /**
    * A human-readable description of the Statistic.
    */
   public String getDescription();

   /**
    * The time of the first measurement represented as a long, whose value is the number of milliseconds since January 1, 1970, 00:00:00.
    */
   public long getStartTime();

   /**
    * The time of the last measurement represented as a long, whose value is the number of milliseconds since January 1, 1970, 00:00:00.
    */
   public long getLastSampleTime();
}

