/**
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package javax.management.j2ee.statistics;

// $Id:JCAConnectionStats.java,v 1.0, 2005-06-24 19:09:18Z, Robert Worsnop$


/**
 * Specifies the statistics provided by a JCA connection
 * 
 * @author thomas.diesler@jboss.org
 */
public interface JCAConnectionStats extends Stats
{
   /**
    * Returns the associated JCAConnectionFactory OBJECT_NAME
    *
    * @return String the OBJECT_NAME of the managed object that identifies the connection factory for this connection getManagedConnectionFactory
    */
   public String getConnectionFactory();

   /**
    * Returns the associated JCAManagedConnectionFactory OBJECT_NAME
    *
    * @return String the OBJECT_NAME of the managed object that identifies the managed connection factory for this connection getWaitTime
    */
   public String getManagedConnectionFactory();

   /**
    * Returns the time spent waiting for a connection to be available
    */
   public TimeStatistic getWaitTime();

   /**
    * Returns the time spent using a connection
    */
   public TimeStatistic getUseTime();

}

