/**
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package javax.management.j2ee;

// $Id:ManagementHome.java,v 1.0, 2005-06-24 19:11:29Z, Robert Worsnop$

import javax.management.*;
import javax.ejb.EJBObject;
import javax.ejb.EJBHome;
import javax.ejb.CreateException;
import java.rmi.RemoteException;
import java.util.Set;

/**
 * The required home interface for the J2EE Management EJB component (MEJB). A J2EE client must be able to create a
 * compliant session object using the specified create() method.
 * 
 * @author thomas.diesler@jboss.org
 */
public interface ManagementHome extends EJBHome
{
   /**
    * Creates an MEJB session object which provides access to the J2EE Management Model
    *
    * @return An MEJB session object which implements javax.management.j2ee.Management
    * @throws CreateException Indicates a failure to create the EJB object
    * @throws RemoteException A communication exception occurred during the execution of a remote method call CreateException
    */
   public Management create() throws CreateException, RemoteException;
}

