/**
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package javax.management.j2ee;

// $Id:ListenerRegistration.java,v 1.0, 2005-06-24 19:10:40Z, Robert Worsnop$

import javax.management.ObjectName;
import javax.management.NotificationListener;
import javax.management.NotificationFilter;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import java.rmi.RemoteException;
import java.io.Serializable;

/**
 * ListenerRegistration defines the methods which clients of the MEJB use to add and remove event listeners.
 *
 * @author thomas.diesler@jboss.org
 */
public interface ListenerRegistration extends Serializable

{
   /**
    * Add a listener to a registered managed object.
    *
    * @param name     The name of the managed object on which the listener should be added.
    * @param listener The listener object which will handle the notifications emitted by the registered managed object.
    * @param filter   The filter object. If filter is null, no filtering will be performed before handling notifications.
    * @param handback The context to be sent to the listener when a notification is emitted.
    * @throws InstanceNotFoundException The managed object name provided does not match any of the registered managed objects.
    * @throws RemoteException           A communication exception occurred during the execution of a remote method call
    */
   public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback)
           throws InstanceNotFoundException, RemoteException;

   /**
    * Remove a listener from a registered managed object.
    *
    * @param name     The name of the managed object on which the listener should be removed.
    * @param listener The listener object which will handle the notifications emitted by the registered managed object.
    *                 This method will remove all the information related to this listener.
    * @throws InstanceNotFoundException The managed object name provided does not match any of the registered managed objects.
    * @throws ListenerNotFoundException The listener is not registered in the managed object.
    * @throws RemoteException           A communication exception occurred during the execution of a remote method call
    */
   public void removeNotificationListener(ObjectName name, NotificationListener listener)
           throws InstanceNotFoundException, ListenerNotFoundException, RemoteException;
}

