/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

package test.compliance.security;

import java.security.PermissionCollection;
import javax.management.MBeanPermission;

import junit.framework.TestCase;

/** Tests of the javax.management.MBeanPermission
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revision:1$
 */
public class MBeanPermissionTestCase
  extends TestCase
{
   public MBeanPermissionTestCase(String s)
   {
      super(s);
   }
   
   public void testCtor()
   {
      MBeanPermission p = new MBeanPermission("*", "*");

      
   }

   public void testImpiles()
   {
      MBeanPermission p0 = new MBeanPermission("*", "*");
      MBeanPermission p1 = new MBeanPermission("*", "*");
      assertTrue("* implies *", p1.implies(p0));

      p0 = new MBeanPermission("[*:*]", "*");
      p1 = new MBeanPermission("[*:*]", "*");
      assertTrue("[*:*] * implies [*:*] *", p1.implies(p0));

      p0 = new MBeanPermission("*", "*");
      p1 = new MBeanPermission("#", "*");
      assertTrue("# implies *", p1.implies(p0));

      p0 = new MBeanPermission("*#", "*");
      p1 = new MBeanPermission("*", "*");
      assertTrue("*# implies *", p1.implies(p0));

      p0 = new MBeanPermission("*", "addNotificationListener");
      p1 = new MBeanPermission("*", "*");
      assertTrue("* * implies * addNotificationListener", p1.implies(p0));

      p0 = new MBeanPermission("*", "queryMBeans");
      p1 = new MBeanPermission("*", "queryNames");
      assertTrue("* queryMBeans implies * queryNames", p0.implies(p1));

      p0 = new MBeanPermission("[MyDomain:type=Product]", "getAttribute");
      p1 = new MBeanPermission("test.Product#Price[MyDomain:type=Product]", "getAttribute");
      assertTrue(p0+" implies "+p1, p0.implies(p1));

      p0 = new MBeanPermission("a.b.c#d[e:f=g]", "*");
      p1 = new MBeanPermission("a.b.c#d[e:f=g]", "getAttribute");
      assertTrue(p0+" implies "+p1, p0.implies(p1));      
   }

   public void testNotImpiled() throws Exception
   {
      MBeanPermission p0 = new MBeanPermission("test.Product#Price[MyDomain:type=Product]", "getAttribute");
      MBeanPermission p1 = new MBeanPermission("test.Product#Cost[MyDomain:type=Product]", "getAttribute");
      assertTrue("!p0 implies p1", p0.implies(p1) == false);      

      p0 = new MBeanPermission("a.b.c#d[e:f=g]", "*");
      p1 = new MBeanPermission("a.b.c#d[e:f=g]", "getAttribute");
      assertTrue(p1+" ! implies "+p0, p1.implies(p0) == false);      
   }
}
