/*
 * JBoss, the OpenSource WebOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.mx.util;

import javax.management.MBeanAttributeInfo;
import javax.management.ObjectName;
import javax.management.monitor.MonitorNotification;

/**
 * @author Scott.Stark@jboss.org
 * @version $Revision:1$
 */
public interface MonitorCallback
{
   /**
    * Perform the monitor specific processing. 
    *
    * @param object the ObservedObject.
    * @param attributeInfo the MBean attribute information.
    * @param value the value to monitor.
    */
   public void monitorCallback(ObservedObject object, MBeanAttributeInfo attributeInfo,
      Object value) throws Exception;

   public MonitorNotification createNotification(String type, Object source, 
               long timeStamp, String message, Object derivedGauge,
               String observedAttribute, ObjectName observedObject,
               Object trigger);
}
