/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

package org.jboss.mx.server;

import javax.management.Descriptor;
import javax.management.DynamicMBean;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistration;
import javax.management.NotificationEmitter;
import javax.management.ObjectName;

/**
 * This interface represents an invoker for an MBean. An invoker is registered
 * to the MBean server to represent an user MBean. The invoker itself implements
 * a <tt>DynamicMBean</tt> interface and therefore receives all attribute
 * accessor and operation invocations targeted at the user MBean.  <p>
 *
 * Invoker implementations may handle the incoming invocations in different
 * ways. The default implementation in <tt>AbstractMBeanInvoker</tt> constructs
 * an <tt>Invocation</tt> object for each invocation and dispatches it through
 * a set of <tt>Interceptor</tt> instances before the invocation is dispatched
 * on the user MBean.  <p>
 * 
 * @author  <a href="mailto:juha@jboss.org">Juha Lindfors</a>.
 * @version $Revision:1$   
 */
public interface MBeanInvoker
   extends DynamicMBean, MBeanRegistration, NotificationEmitter, Suspendable
{
   MBeanInfo getMetaData();
   
   Object getResource();
   
   void setResource(Object resource);

   ObjectName getObjectName();

   void updateAttributeInfo(Descriptor attrDesc) throws MBeanException;
}
      



