/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

package org.jboss.mx.server;

import org.jboss.mx.interceptor.AbstractInterceptor;


/**
 *
 * @author  <a href="mailto:juha@jboss.org">Juha Lindfors</a>.
 * @version $Revision:1$
 *   
 */
public class Invocation
   extends InvocationContext   
{
   private Object[] args;
   
   private InvocationContext ctx;

   // Constructors --------------------------------------------------
   public Invocation() {}
   
   public Invocation(InvocationContext ic)
   {
      addContext(ic);
   }
   
   
   // Public --------------------------------------------------------
   
   public void addContext(final InvocationContext ctx)
   {
      super.copy(ctx);
      this.ctx = ctx;
   }

   public void setArgs(Object[] args)
   {
      this.args = args;
   }

   public Object[] getArgs()
   {
      return args;
   }
   
   int ic_counter = 0;
   
   public AbstractInterceptor nextInterceptor()
   {
      if (interceptors == null)
         return null;
         
      if (ic_counter < interceptors.size())
          return (AbstractInterceptor)interceptors.get(ic_counter++);
      else
         return null;
   }
      
      
   public Object invoke() throws Throwable
   {
      AbstractInterceptor ic = nextInterceptor();
      
      if (ic == null)
         return dispatch();
      else
         return ic.invoke(this);
         
   }
   
   public Object dispatch() throws Throwable
   {
      return dispatcher.invoke(this);
   }
   
   Object retVal = null;

   
   
   public String toString()
   {
      return getName() + " " + getType();
   }
   
   public Class getAttributeTypeClass() throws ClassNotFoundException
   {
      return ctx.getAttributeTypeClass();
   }

   public Class getReturnTypeClass() throws ClassNotFoundException
   {
      return ctx.getReturnTypeClass();
   }

   public Class[] getSignatureClasses() throws ClassNotFoundException
   {
      return ctx.getSignatureClasses();
   }
}
      



