/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package javax.management;

import org.jboss.mx.util.JBossNotificationBroadcasterSupport;

/**
 * A helper class for notification broadcasters/emitters
 *
 * @author  <a href="mailto:juha@jboss.org">Juha Lindfors</a>.
 * @author  <a href="mailto:Adrian.Brock@HappeningTimes.com">Adrian Brock</a>.
 * @version $Revision:1$
 */
public class NotificationBroadcasterSupport implements NotificationEmitter
{
   /** The delegate */
   private JBossNotificationBroadcasterSupport delegate = new JBossNotificationBroadcasterSupport();

   /**
    * Construct the new notification broadcaster support object
    */
   public NotificationBroadcasterSupport()
   {
   }

   public void addNotificationListener(NotificationListener listener,
                                       NotificationFilter filter,
                                       Object handback)
   {
      delegate.addNotificationListener(listener, filter, handback);
   }

   public void removeNotificationListener(NotificationListener listener)
       throws ListenerNotFoundException
   {
      delegate.removeNotificationListener(listener);
   }

   public void removeNotificationListener(NotificationListener listener,
                                          NotificationFilter filter,
                                          Object handback)
      throws ListenerNotFoundException
   {
      delegate.removeNotificationListener(listener, filter, handback);
   }

   public MBeanNotificationInfo[] getNotificationInfo()
   {
      return delegate.getNotificationInfo();
   }

   public void sendNotification(Notification notification)
   {
      delegate.sendNotification(notification);
   }

   /**
    * Handle the notification, the default implementation is to synchronously invoke the listener.
    *
    * @param listener the listener to notify
    * @param notification the notification
    * @param handback the handback object
    */
   protected void handleNotification(NotificationListener listener,
                                     Notification notification,
                                     Object handback)
   {
      delegate.handleNotification(listener, notification, handback);
   }
}
