/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package javax.management;

/**
 * This interface must be implemented by all MBeans that emit notifications.<p>
 *
 * New code should implement the NotificationEmitter interface
 *
 * @see  javax.management.NotificationListener
 * @see  javax.management.NotificationFilter
 * @see  javax.management.NotificationEmitter
 *
 * @author     <a href="mailto:juha@jboss.org">Juha Lindfors</a>.
 * @version    $Revision:1$
 */
public interface NotificationBroadcaster
{
   /**
    * Add a listener to an MBean.
    *
    * @param   listener    implementation of the listener object
    * @param   filter      implementation of the filter object or <tt>null</tt>
    *                      if no filtering is required
    * @param   handback    A handback object associated with each notification
    *                      sent by this notification broadcaster.
    *
    * @throws  IllegalArgumentException if listener is <tt>null</tt>
    */
   public void addNotificationListener(NotificationListener listener,
                                       NotificationFilter filter,
                                       Object handback)
       throws IllegalArgumentException;

   /**
    * Removes a listener from an MBean.
    *
    * @param   listener the listener object to remove
    *
    * @throws ListenerNotFoundException if the listener was not found
    */
   public void removeNotificationListener(NotificationListener listener)
       throws ListenerNotFoundException;

   /**
    * Returns the notification metadata associated with the MBean.
    *
    * @see  javax.management.MBeanNotificationInfo
    *
    * @return  MBean's notification metadata
    */
   public MBeanNotificationInfo[] getNotificationInfo();

}

