/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

// $Id:MBeanConstructorInfoSer.java,v 1.0, 2005-06-24 19:11:45Z, Robert Worsnop$

package org.jboss.net.jmx.adaptor;

import org.jboss.axis.Constants;
import org.jboss.axis.encoding.SerializationContext;
import org.jboss.axis.encoding.Serializer;
import org.jboss.axis.wsdl.fromJava.Types;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;

import javax.management.MBeanConstructorInfo;
import javax.xml.namespace.QName;
import java.io.IOException;

/**
 * An <code>MBeanConstructorInfoSer</code> is be used to serialize
 * MBeanConstructorInfo using the <code>SOAP-ENC</code>
 * encoding style.<p>
 *
 * @author <a href="mailto:a_taherkordi@users.sourceforge.net">Alireza Taherkordi</a>
 * @version $Revision:1$
 */
public class MBeanConstructorInfoSer implements Serializer
{

   public void serialize(QName name,
                         Attributes attributes,
                         Object value,
                         SerializationContext context)
           throws IOException
   {
      if (!(value instanceof MBeanConstructorInfo))
         throw new IOException("Can't serialize a "
                 + value.getClass().getName()
                 + " instance with a MBeanConstructorInfo Serializer.");
      context.startElement(name, attributes);

      MBeanConstructorInfo info = (MBeanConstructorInfo)value;
      context.serialize(new QName("", "name"), null, info.getName());
      context.serialize(new QName("", "description"),
              null,
              info.getDescription());
      context.serialize(new QName("", "signature"), null, info.getSignature());

      context.endElement();
      return;

   }

   public Element writeSchema(Class aClass, Types types) throws Exception
   {
      return null;
   }

   public String getMechanismType()
   {
      return Constants.AXIS_SAX;
   }

}