/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

// $Id:WsdlAwareHttpActionHandler.java,v 1.0, 2005-06-24 19:19:20Z, Robert Worsnop$


package org.jboss.net.axis.server;

import org.jboss.axis.AxisFault;
import org.jboss.axis.MessageContext;
import org.jboss.axis.handlers.http.HTTPActionHandler;

/**
 * <p>
 * This HttpActionHandler will influence the wsdl-generation of
 * action aware service providers, such as {@link org.jboss.net.axis.server.EJBProvider}.
 * </p>
 * @author <a href="mailto:Christoph.Jung@infor.de">Christoph G. Jung</a>
 * @since 27.03.2003
 * @version $Revision:1$
 */

public class WsdlAwareHttpActionHandler extends HTTPActionHandler
{

   /**
    * sets the presence flag in the context such that any provider
    * that uses this flag will be able to generate soap-action 
    * information.
    * @see org.jboss.axis.Handler#generateWSDL(org.jboss.axis.MessageContext)
    */
   public void generateWSDL(MessageContext arg0) throws AxisFault
   {
      arg0.setProperty(Constants.ACTION_HANDLER_PRESENT_PROPERTY, Boolean.TRUE);
      super.invoke(arg0);
   }

}
