/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

// $Id:ServiceClassLoaderAwareWSDDHandlerProvider.java,v 1.0, 2005-06-24 19:15:58Z, Robert Worsnop$
package org.jboss.net.axis;

import org.jboss.axis.EngineConfiguration;
import org.jboss.axis.Handler;
import org.jboss.axis.deployment.wsdd.WSDDService;
import org.jboss.axis.deployment.wsdd.providers.WSDDHandlerProvider;

/**
 * <p>
 * A subclass of the official handler provider that
 * is able to load the specified handler classes from
 * the service deployment classloader.
 * </p>
 * @author jung
 * @since 12.03.2003
 * @version $Revision:1$
 */

public class ServiceClassLoaderAwareWSDDHandlerProvider
        extends WSDDHandlerProvider
{

   /* (non-Javadoc)
    * @see org.jboss.axis.deployment.wsdd.WSDDProvider#newProviderInstance(org.jboss.axis.deployment.wsdd.WSDDService, org.jboss.axis.EngineConfiguration)
    */
   public Handler newProviderInstance(WSDDService arg0,
                                      EngineConfiguration arg1)
           throws Exception
   {

      Deployment deployment = (Deployment)arg0.getParametersTable().
              get(Constants.SERVICE_DEPLOYMENT_PARAMETER);

      if (deployment != null)
      {
         ClassLoader loader = deployment.getDeploymentLoader();
         ClassLoader old = Thread.currentThread().getContextClassLoader();
         Thread.currentThread().setContextClassLoader(loader);
         try
         {
            return super.newProviderInstance(arg0, arg1);
         }
         finally
         {
            Thread.currentThread().setContextClassLoader(old);
         }
      }
      else
      {
         return super.newProviderInstance(arg0, arg1);
      }
   }

}
