/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.w3c.dom;

// $Id:TypeInfo.java,v 1.0, 2005-06-24 19:18:27Z, Robert Worsnop$

/**
 * The <code>TypeInfo</code> interface represents a type referenced from
 * <code>Element</code> or <code>Attr</code> nodes, specified in the schemas 
 * associated with the document. The type is a pair of a namespace URI and 
 * name properties, and depends on the document's schema.
 *
 * @since DOM Level 3
 */
public interface TypeInfo
{
   /**
    * The name of a type declared for the associated element or attribute,
    * or <code>null</code> if unknown.
    */
   public String getTypeName();

   /**
    * The namespace of the type declared for the associated element or
    * attribute or <code>null</code> if the element does not have
    * declaration or if no namespace information is available.
    */
   public String getTypeNamespace();

   public static final int DERIVATION_RESTRICTION = 0x00000001;
   public static final int DERIVATION_EXTENSION = 0x00000002;
   public static final int DERIVATION_UNION = 0x00000004;
   public static final int DERIVATION_LIST = 0x00000008;

   /**
    *  This method returns if there is a derivation between the reference
    * type definition, i.e. the <code>TypeInfo</code> on which the method
    * is being called, and the other type definition, i.e. the one passed
    * as parameters.
    */
   public boolean isDerivedFrom(String typeNamespaceArg, String typeNameArg, int derivationMethod);

}
